/*
 * Decompiled with CFR 0.152.
 */
package com.easou.epay_all.util;

import android.util.Log;
import com.easou.epay_all.activity.FormatString;
import com.easou.epay_all.util.Constant;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.LinkedList;

public class Lg {
    public static final String TAG = "easou";
    public static boolean isDebug = true;
    private static LinkedList<LogContent> logs = new LinkedList();
    private static boolean isWritingLog = false;
    private static final byte[] LOCK_LOGS = new byte[0];
    private static final byte[] LOCK_LOG_FILE_WRITE = new byte[0];
    private static final int V = 0;
    private static final int D = 1;
    private static final int I = 2;
    private static final int W = 3;
    private static final int E = 4;

    private static boolean isNeedSaveLogToFile(String tag, int level, String msg) {
        return level == 4;
    }

    public static void v(String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.v((String)TAG, (String)t);
            Lg.writeToLogFile(TAG, 0, t);
        }
    }

    public static void v(String msg, Throwable thr) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.v((String)TAG, (String)t, (Throwable)thr);
            Lg.writeToLogFile(TAG, 0, t);
        }
    }

    public static void v(String tag, String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.v((String)tag, (String)t);
            Lg.writeToLogFile(tag, 0, t);
        }
    }

    public static void d(String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.d((String)TAG, (String)t);
            Lg.writeToLogFile(TAG, 1, t);
        }
    }

    public static void d(String tag, String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.d((String)tag, (String)t);
            Lg.writeToLogFile(tag, 1, t);
        }
    }

    public static void d(String msg, Throwable thr) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.d((String)TAG, (String)t, (Throwable)thr);
            Lg.writeToLogFile(TAG, 1, t);
        }
    }

    public static void i(String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.i((String)TAG, (String)t);
            Lg.writeToLogFile(TAG, 2, t);
        }
    }

    public static void i(String tag, String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.i((String)tag, (String)t);
            Lg.writeToLogFile(tag, 2, t);
        }
    }

    public static void i(String msg, Throwable thr) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.i((String)TAG, (String)t, (Throwable)thr);
            Lg.writeToLogFile(TAG, 2, t);
        }
    }

    public static void w(String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.w((String)TAG, (String)t);
            Lg.writeToLogFile(TAG, 3, t);
        }
    }

    public static void w(String tag, String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.w((String)tag, (String)t);
            Lg.writeToLogFile(tag, 3, t);
        }
    }

    public static void w(String msg, Throwable thr) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.w((String)TAG, (String)t, (Throwable)thr);
            Lg.writeToLogFile(TAG, 3, t);
        }
    }

    public static void e(String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.e((String)TAG, (String)t);
            Lg.writeToLogFile(TAG, 4, t);
        }
    }

    public static void e(String tag, String msg) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.e((String)tag, (String)t);
            Lg.writeToLogFile(tag, 4, t);
        }
    }

    public static void e(String msg, Throwable thr) {
        if (isDebug) {
            String t = Lg.buildMessage(msg);
            Log.e((String)TAG, (String)t, (Throwable)thr);
            Lg.writeToLogFile(TAG, 4, t);
        }
    }

    protected static String buildMessage(String msg) {
        StackTraceElement caller = new Throwable().fillInStackTrace().getStackTrace()[2];
        return caller.getClassName() + "." + caller.getMethodName() + "(): " + msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeToLogFile(String tag, int level, String msg) {
        if (!Lg.isNeedSaveLogToFile(tag, level, msg)) return;
        byte[] byArray = LOCK_LOGS;
        synchronized (LOCK_LOGS) {
            logs.add(new LogContent(tag, level, msg));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Lg.writeToLogFileAsynch();
            return;
        }
    }

    private static void writeToLogFileAsynch() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!isWritingLog) {
                    byte[] byArray = LOCK_LOG_FILE_WRITE;
                    synchronized (byArray) {
                        block17: {
                            if (isWritingLog) {
                                return;
                            }
                            isWritingLog = true;
                            byte[] byArray2 = LOCK_LOGS;
                            synchronized (byArray2) {
                                if (logs.size() == 0) {
                                    isWritingLog = false;
                                    return;
                                }
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            OutputStreamWriter fw = null;
                            try {
                                File dir = new File(Constant.LOG_SAVEPATH);
                                if (!dir.exists() && !dir.mkdirs()) {
                                    return;
                                }
                                File logFile = new File(dir, "Log" + FormatString.getDate() + ".txt");
                                if (!logFile.exists()) {
                                    logFile.createNewFile();
                                }
                                fw = new FileWriter(logFile, true);
                                fw.write(Lg.getAllLog());
                                fw.flush();
                                fw.close();
                                fw = null;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                if (fw == null) break block17;
                                try {
                                    fw.close();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        isWritingLog = false;
                    }
                    Lg.writeToLogFileAsynch();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAllLog() {
        byte[] byArray = LOCK_LOGS;
        synchronized (LOCK_LOGS) {
            block5: {
                if (logs.size() != 0) break block5;
                // ** MonitorExit[var0] (shouldn't be in output)
                return "";
            }
            StringBuilder sb = new StringBuilder();
            while (logs.size() > 1) {
                sb.append(String.valueOf(logs.remove(0).toString()) + "\n");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sb.toString();
        }
    }

    static class LogContent {
        String tag;
        int level;
        String msg;
        Date datetime = new Date();

        public LogContent(String tag, int level, String msg) {
            this.tag = tag;
            this.level = level;
            this.msg = msg;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String toString() {
            return "[" + FormatString.getDatetimeMillisecond(this.datetime) + "-" + this.tag + "-" + this.level + "] " + this.msg;
        }
    }
}

