/*
 * Decompiled with CFR 0.152.
 */
package com.easou.epay_all.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import com.easou.epay_all.activity.EasouPayActivity;
import com.easou.epay_all.all_pay.shenzhoupay.ShenzhouPay;
import com.easou.epay_all.all_pay.sms.SMSPay;
import com.easou.epay_all.all_pay.yibao.YeePay;
import com.easou.epay_all.all_pay.zhifubao.AliPay;
import com.easou.epay_all.json.PayParam;
import com.easou.epay_all.util.ImageUtil;

public class FeeView
extends RelativeLayout
implements View.OnClickListener {
    private EasouPayActivity activity;
    private RelativeLayout feeHitView;
    private ImageView topView;
    private ImageView midView;
    private TableLayout tableLayout;
    private int tableWidth;
    private Drawable drawableLogo;
    private Drawable drawableConfirme_text;
    int logoHeight;
    int confirme_textHeight;
    private int payType;
    public static int PAYTYPE_SHOUJIHUAFEI = 0;
    public static int PAYTYPE_ZHIFUBAO = 1;
    public static int PAYTYPE_SHENZHOUFU = 2;
    public static int PAYTYPE_SHOUJIQIANBAO = 3;
    public static int PAYTYPE_YIBAO = 4;
    public static int PAYTYPE_YINLIAN = 5;
    public static int PAYTYPE_LIANTONG;
    int index = 0;
    TableRow row = null;
    int tableItemWidth = (int)((float)ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/shenzhou.png", this.getContext()).getIntrinsicWidth() * ImageUtil.getScreenDensity(this.getContext()));
    int tableItemHeight = (int)((float)ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/shenzhou.png", this.getContext()).getIntrinsicHeight() * ImageUtil.getScreenDensity(this.getContext()));
    private OnButtonClick btnClick;

    public FeeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.activity = (EasouPayActivity)context;
        this.init();
    }

    private void init() {
        this.feeHitView = new RelativeLayout(this.getContext(), null);
        this.setBackgroundColor(Color.argb((int)51, (int)0, (int)0, (int)0));
        this.feeHitView.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/background.png", this.getContext()));
        int feeWid = (int)(300.0f * ImageUtil.getScreenDensity(this.getContext()));
        int feeHei = (int)(354.0f * ImageUtil.getScreenDensity(this.getContext()));
        int feeMar = (int)(10.0f * ImageUtil.getScreenDensity(this.getContext()));
        RelativeLayout.LayoutParams feeParams = new RelativeLayout.LayoutParams(ImageUtil.getScreenWid(this.getContext()), ImageUtil.getScreenHei(this.getContext()));
        feeParams.addRule(15, -1);
        feeParams.addRule(13, -1);
        this.feeHitView.setId(1000);
        this.addView((View)this.feeHitView, (ViewGroup.LayoutParams)feeParams);
        int topWid = (int)(70.0f * ImageUtil.getScreenDensity(this.getContext()));
        int topHei = (int)(78.0f * ImageUtil.getScreenDensity(this.getContext()));
        int topMa = (int)(10.0f * ImageUtil.getScreenDensity(this.getContext()));
        this.drawableLogo = ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/logo.png", this.getContext());
        this.logoHeight = ImageUtil.getDisplayMetricsWidth(this.activity) * this.drawableLogo.getIntrinsicHeight() / this.drawableLogo.getIntrinsicWidth();
        RelativeLayout.LayoutParams topParams = new RelativeLayout.LayoutParams(-1, 108);
        System.out.println("\u5bc6\u5ea6=" + ImageUtil.getScreenDensity(this.getContext()));
        topParams.addRule(14, -1);
        topParams.addRule(10, -1);
        topParams.topMargin = topMa;
        this.topView = new ImageView(this.getContext());
        this.topView.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/logo.png", this.getContext()));
        this.topView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.topView.setId(1999);
        this.feeHitView.addView((View)this.topView, (ViewGroup.LayoutParams)topParams);
        int midWid = (int)(250.0f * ImageUtil.getScreenDensity(this.getContext()));
        int midHei = (int)(50.0f * ImageUtil.getScreenDensity(this.getContext()));
        int topMar = (int)(0.0f * ImageUtil.getScreenDensity(this.getContext()));
        int leftMar = (int)(15.0f * ImageUtil.getScreenDensity(this.getContext()));
        RelativeLayout.LayoutParams midParams = null;
        this.drawableConfirme_text = ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/confirme_text.png", this.getContext());
        int confirme_textWidth = (int)((float)this.drawableLogo.getIntrinsicWidth() * ImageUtil.getScreenDensity(this.getContext()) * (float)ImageUtil.getDisplayMetricsWidth(this.activity) / (float)ImageUtil.getUiWidth());
        this.confirme_textHeight = confirme_textWidth * this.drawableConfirme_text.getIntrinsicHeight() / this.drawableConfirme_text.getIntrinsicWidth();
        midParams = new RelativeLayout.LayoutParams(confirme_textWidth, 48);
        midParams.addRule(3, this.topView.getId());
        midParams.addRule(9, -1);
        midParams.leftMargin = leftMar;
        this.midView = new ImageView(this.getContext());
        this.midView.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/confirme_text.png", this.getContext()));
        this.midView.setId(2000);
        this.feeHitView.addView((View)this.midView, (ViewGroup.LayoutParams)midParams);
        int leftMarging = (int)(20.0f * ImageUtil.getScreenDensity(this.getContext()));
        int topMarging = (int)(10.0f * ImageUtil.getScreenDensity(this.getContext()));
        this.tableWidth = ImageUtil.getDisplayMetricsWidth(this.activity) - leftMarging * 2;
        int boMarging = (int)(15.0f * ImageUtil.getScreenDensity(this.getContext()));
        int hei = (int)(90.0f * ImageUtil.getScreenDensity(this.getContext()));
        RelativeLayout.LayoutParams webViewParaams = new RelativeLayout.LayoutParams(-1, -1);
        webViewParaams.addRule(3, this.midView.getId());
        webViewParaams.topMargin = topMarging;
        webViewParaams.leftMargin = leftMarging;
        webViewParaams.rightMargin = leftMarging;
        this.tableLayout = new TableLayout(this.getContext());
        this.tableLayout.setId(2011);
        this.feeHitView.addView((View)this.tableLayout, (ViewGroup.LayoutParams)webViewParaams);
    }

    public void onClick(View v) {
    }

    public void updateUI() {
        if (this.index == 0 && this.activity.response != null && this.activity.response.getList() != null && this.activity.response.getList().size() > 0) {
            this.index = 0;
            for (PayParam pam : this.activity.response.getList()) {
                ImageButton aliButton;
                if (pam.getGatewayCode().equals("paypal")) {
                    aliButton = this.getButtonByCode(pam, 0);
                    this.addTableView(aliButton);
                    continue;
                }
                if (pam.getGatewayCode().equals("mobileWallet")) {
                    aliButton = this.getButtonByCode(pam, 1);
                    this.addTableView(aliButton);
                    continue;
                }
                if (pam.getGatewayCode().equals("callFee")) {
                    if (this.activity.response.getSmsPriority().trim().equals("1") || !this.activity.response.getSmsPriority().trim().equals("0")) continue;
                    aliButton = this.getButtonByCode(pam, 2);
                    this.addTableView(aliButton);
                    continue;
                }
                if (pam.getGatewayCode().equals("yeePay")) {
                    aliButton = this.getButtonByCode(pam, 3);
                    this.addTableView(aliButton);
                    continue;
                }
                if (pam.getGatewayCode().equals("divinePay")) {
                    aliButton = this.getButtonByCode(pam, 4);
                    this.addTableView(aliButton);
                    continue;
                }
                if (pam.getGatewayCode().equals("UnionPay")) {
                    aliButton = this.getButtonByCode(pam, 5);
                    this.addTableView(aliButton);
                    continue;
                }
                if (!pam.getGatewayCode().equals("UnionPay")) continue;
                aliButton = this.getButtonByCode(pam, 5);
                this.addTableView(aliButton);
            }
        }
    }

    private void addTableView(ImageButton btn) {
        if (this.index % 3 == 0) {
            this.row = new TableRow((Context)this.activity);
            TableLayout.LayoutParams tableLayoutParams = new TableLayout.LayoutParams(this.tableWidth, -1);
            this.tableLayout.addView((View)this.row, (ViewGroup.LayoutParams)tableLayoutParams);
        }
        TableRow.LayoutParams tableRow_layoutParams = new TableRow.LayoutParams(this.tableWidth / 3, this.tableWidth / 3 * this.tableItemHeight / this.tableItemWidth);
        tableRow_layoutParams.bottomMargin = ImageUtil.getDisplayMetricsHeight(this.activity) * 1 / ImageUtil.getUiHeight() * (int)ImageUtil.getScreenDensity(this.getContext());
        this.row.addView((View)btn, (ViewGroup.LayoutParams)tableRow_layoutParams);
        ++this.index;
    }

    private ImageButton getButtonByCode(final PayParam pam, int id) {
        ImageButton button = null;
        switch (id) {
            case 0: {
                button = new ImageButton((Context)this.activity, null);
                button.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/ali.png", this.getContext()));
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeeView.this.payType = PAYTYPE_ZHIFUBAO;
                        AliPay.getInstance(FeeView.this.activity).performPay(((FeeView)FeeView.this).activity.response);
                        FeeView.this.activity.submitOrder(pam.getGatewayId(), FeeView.this.payType);
                    }
                });
                break;
            }
            case 1: {
                button = new ImageButton((Context)this.activity, null);
                button.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/package.png", this.getContext()));
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeeView.this.payType = PAYTYPE_SHOUJIQIANBAO;
                        FeeView.this.activity.cmmPackagePay(((FeeView)FeeView.this).activity.response);
                        FeeView.this.activity.submitOrder(pam.getGatewayId(), FeeView.this.payType);
                    }
                });
                break;
            }
            case 2: {
                button = new ImageButton((Context)this.activity, null);
                button.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/sms.png", this.getContext()));
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeeView.this.payType = PAYTYPE_SHOUJIHUAFEI;
                        ((FeeView)FeeView.this).activity.smsPay = new SMSPay();
                        ((FeeView)FeeView.this).activity.smsPay.pay(FeeView.this.activity, ((FeeView)FeeView.this).activity.response);
                        FeeView.this.activity.submitOrder(pam.getGatewayId(), FeeView.this.payType);
                    }
                });
                break;
            }
            case 3: {
                button = new ImageButton((Context)this.activity, null);
                this.activity.yeePay = new YeePay(this.activity);
                button.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/yee.png", this.getContext()));
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeeView.this.payType = PAYTYPE_YIBAO;
                        ((FeeView)FeeView.this).activity.yeePay.yibaoPay(((FeeView)FeeView.this).activity.response);
                        FeeView.this.activity.submitOrder(pam.getGatewayId(), FeeView.this.payType);
                    }
                });
                break;
            }
            case 4: {
                button = new ImageButton((Context)this.activity, null);
                this.activity.shenzhouPay = new ShenzhouPay();
                button.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/shenzhou.png", this.getContext()));
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeeView.this.payType = PAYTYPE_SHENZHOUFU;
                        ((FeeView)FeeView.this).activity.shenzhouPay.pay(FeeView.this.activity, ((FeeView)FeeView.this).activity.response);
                        FeeView.this.activity.submitOrder(pam.getGatewayId(), FeeView.this.payType);
                    }
                });
                break;
            }
            case 5: {
                button = new ImageButton((Context)this.activity, null);
                button.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/tclpay.png", this.getContext()));
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeeView.this.payType = PAYTYPE_YINLIAN;
                        FeeView.this.activity.submitOrder(pam.getGatewayId(), FeeView.this.payType);
                    }
                });
                break;
            }
        }
        return button;
    }

    public void setBtnClick(OnButtonClick btnClick) {
        this.btnClick = btnClick;
    }

    public static interface OnButtonClick {
        public void onConcleBtnClick();

        public void onConfirmBtnClick();
    }
}

