/*
 * Decompiled with CFR 0.152.
 */
package com.easou.epay_all.all_pay.zhifubao;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.easou.epay_all.all_pay.zhifubao.BaseHelper;
import com.easou.epay_all.all_pay.zhifubao.FileDownloader;
import com.easou.epay_all.all_pay.zhifubao.NetworkManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"HandlerLeak"})
public class MobileSecurePayHelper {
    static final String TAG = "MobileSecurePayHelper";
    private ProgressDialog mProgress = null;
    Context mContext = null;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            try {
                Log.e((String)MobileSecurePayHelper.TAG, (String)("msg = " + msg));
                switch (msg.what) {
                    case 2: 
                    case 3: 
                    case 4: {
                        Log.i((String)MobileSecurePayHelper.TAG, (String)"show Install dialog");
                        MobileSecurePayHelper.this.closeProgress();
                        String cachePath = (String)msg.obj;
                        MobileSecurePayHelper.this.showInstallConfirmDialog(MobileSecurePayHelper.this.mContext, cachePath);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public MobileSecurePayHelper(Context context) {
        this.mContext = context;
    }

    public boolean detectMobile_sp() {
        boolean isMobile_spExist = this.isMobile_spExist();
        if (!isMobile_spExist) {
            File cacheDir = this.mContext.getCacheDir();
            final String cachePath = String.valueOf(cacheDir.getAbsolutePath()) + "/temp.apk";
            this.retrieveApkFromAssets(this.mContext, "Alipay_msp_online.apk", cachePath);
            this.mProgress = BaseHelper.showProgress(this.mContext, null, "\u6b63\u5728\u68c0\u6d4b\u5b89\u5168\u652f\u4ed8\u670d\u52a1\u7248\u672c", false, true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PackageInfo apkInfo = MobileSecurePayHelper.getApkInfo(MobileSecurePayHelper.this.mContext, cachePath);
                    String newApkdlUrl = MobileSecurePayHelper.this.checkNewUpdate(apkInfo);
                    if (newApkdlUrl != null) {
                        FileDownloader fd = new FileDownloader();
                        fd.setFileUrl(newApkdlUrl);
                        fd.setSavePath(cachePath);
                        fd.setProgressOutput(new FileDownloader.IDownloadProgress(){

                            @Override
                            public void downloadSucess() {
                                Message msg = MobileSecurePayHelper.this.mHandler.obtainMessage(2, (Object)cachePath);
                                MobileSecurePayHelper.this.mHandler.sendMessage(msg);
                            }

                            @Override
                            public void downloadProgress(float progress) {
                            }

                            @Override
                            public void downloadFail() {
                                Message msg = MobileSecurePayHelper.this.mHandler.obtainMessage(3, (Object)cachePath);
                                MobileSecurePayHelper.this.mHandler.sendMessage(msg);
                            }
                        });
                        fd.start();
                    } else {
                        Message msg = MobileSecurePayHelper.this.mHandler.obtainMessage(4, (Object)cachePath);
                        MobileSecurePayHelper.this.mHandler.sendMessage(msg);
                    }
                }
            }).start();
        }
        return isMobile_spExist;
    }

    public void showInstallConfirmDialog(final Context context, final String cachePath) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)"\u5b89\u88c5\u63d0\u793a");
        builder.setMessage((CharSequence)"\u4e3a\u4fdd\u8bc1\u60a8\u7684\u4ea4\u6613\u5b89\u5168\uff0c\u9700\u8981\u60a8\u5b89\u88c5\u79fb\u52a8\u5feb\u6377\u652f\u4ed8\uff0c\u624d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u3002\n\n\u70b9\u51fb\u786e\u5b9a\uff0c\u7acb\u5373\u5b89\u88c5\u3002");
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                BaseHelper.chmod("777", cachePath);
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.addFlags(0x10000000);
                intent.setDataAndType(Uri.parse((String)("file://" + cachePath)), "application/vnd.android.package-archive");
                context.startActivity(intent);
            }
        });
        builder.setNegativeButton((CharSequence)context.getResources().getString(0x1040000), null);
        builder.show();
    }

    public boolean isMobile_spExist() {
        PackageManager manager = this.mContext.getPackageManager();
        List pkgList = manager.getInstalledPackages(0);
        int i = 0;
        while (i < pkgList.size()) {
            PackageInfo pI = (PackageInfo)pkgList.get(i);
            if (pI.packageName.equalsIgnoreCase("com.alipay.android.app")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean retrieveApkFromAssets(Context context, String fileName, String path) {
        boolean bRet = false;
        try {
            InputStream is = context.getAssets().open(fileName);
            File file = new File(path);
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = is.read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            is.close();
            bRet = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bRet;
    }

    public static PackageInfo getApkInfo(Context context, String archiveFilePath) {
        PackageManager pm = context.getPackageManager();
        PackageInfo apkInfo = pm.getPackageArchiveInfo(archiveFilePath, 128);
        return apkInfo;
    }

    public String checkNewUpdate(PackageInfo packageInfo) {
        String url = null;
        try {
            JSONObject resp = this.sendCheckNewUpdate(packageInfo.versionName);
            if (resp.getString("needUpdate").equalsIgnoreCase("true")) {
                url = resp.getString("updateUrl");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    public JSONObject sendCheckNewUpdate(String versionName) {
        JSONObject objResp = null;
        try {
            JSONObject req = new JSONObject();
            req.put("action", (Object)"update");
            JSONObject data = new JSONObject();
            data.put("platform", (Object)"android");
            data.put("version", (Object)versionName);
            data.put("partner", (Object)"");
            req.put("data", (Object)data);
            objResp = this.sendRequest(req.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return objResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject sendRequest(String content) {
        NetworkManager nM = new NetworkManager(this.mContext);
        JSONObject jsonResponse = null;
        try {
            String response = null;
            NetworkManager networkManager = nM;
            synchronized (networkManager) {
                response = nM.SendAndWaitResponse(content, "http://epay.kdbooks.cn:8000/epayPaypal");
            }
            jsonResponse = new JSONObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (jsonResponse != null) {
            BaseHelper.log(TAG, jsonResponse.toString());
        }
        return jsonResponse;
    }

    public boolean retrieveApkFromNet(Context context, String url, String filename) {
        boolean ret = false;
        try {
            NetworkManager nm = new NetworkManager(this.mContext);
            ret = nm.urlDownloadToFile(context, url, filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    void closeProgress() {
        try {
            if (this.mProgress != null) {
                this.mProgress.dismiss();
                this.mProgress = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

