/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.sms;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.android.easou.epay.db.SharePreferUtil;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.Frequency;
import com.android.easou.epay.util.SystemInfo;
import com.android.easou.epay.util.Tools;

public class SMSCTools {
    private final Context context;

    public SMSCTools(Context context) {
        this.context = context;
    }

    public String dogetSMSC() {
        String cardType = SystemInfo.getCardType(this.context);
        if (cardType.equals("telecom") || cardType.equals("unknow")) {
            return null;
        }
        String smsc = SharePreferUtil.getSMSCFromDataBase(this.context);
        if (smsc != null) {
            return smsc;
        }
        smsc = this.getInboxSMSC();
        if (smsc != null) {
            SharePreferUtil.saveSMSCToDataBase(smsc, this.context);
            return smsc;
        }
        return smsc;
    }

    private String getInboxSMSC() {
        String[] projection = new String[]{"address", "service_center"};
        try {
            String cardType = SystemInfo.getCardType(this.context);
            Cursor myCursor = this.context.getContentResolver().query(Uri.parse((String)"content://sms/inbox"), projection, "length(address)=11 or length(address)=14", null, "_id desc");
            if (myCursor != null && myCursor.moveToFirst()) {
                Frequency fre = new Frequency();
                int index = 0;
                do {
                    EpayLog.showSaveLog("getInboxSMSC", "address=" + myCursor.getString(0) + "service_center=" + myCursor.getString(1));
                    String address = myCursor.getString(0);
                    if (Tools.isPhoneNumberValid(address)) {
                        EpayLog.showSaveLog("info", "address=" + address + "isPhoneNumber");
                        String smsc = myCursor.getString(1);
                        if (smsc == null || smsc.trim().equals("")) continue;
                        if (smsc.startsWith("+86")) {
                            smsc = smsc.substring(3);
                        }
                        EpayLog.showSaveLog("info", "last smsc=" + smsc);
                        if (cardType.equals("mobile") && smsc.startsWith("13800")) {
                            fre.addStatistics(smsc);
                            ++index;
                            continue;
                        }
                        if (!cardType.equals("unicom") || !smsc.startsWith("13010")) continue;
                        fre.addStatistics(smsc);
                        ++index;
                        continue;
                    }
                    EpayLog.showSaveLog("info", "address=" + address + "isNotPhoneNumber");
                } while (myCursor.moveToNext());
                String smsc = fre.getMaxValueItem().getKey();
                EpayLog.showSaveLog("", "\u6700\u9891\u7e41\u7684\u4e2d\u5fc3\u53f7\u662f\uff1a" + smsc);
                return smsc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

