/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.protocolstack;

import android.content.Context;
import android.util.Xml;
import com.android.easou.epay.bean.EpayBean;
import com.android.easou.epay.bean.FeeBean;
import com.android.easou.epay.bean.IVRBean;
import com.android.easou.epay.bean.LiandongBean;
import com.android.easou.epay.bean.LiantongBean;
import com.android.easou.epay.bean.MMBean;
import com.android.easou.epay.bean.MusicWap;
import com.android.easou.epay.bean.OnlineGameWap;
import com.android.easou.epay.bean.Procedure;
import com.android.easou.epay.bean.SMSBean;
import com.android.easou.epay.bean.Wap;
import com.android.easou.epay.db.SharePreferUtil;
import com.android.easou.epay.ui.FeeView;
import com.android.easou.epay.util.EpayLog;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class EpayXMLParser {
    private List<FeeBean> allFees;
    private FeeBean currentBean;
    private Procedure currentProed;
    private Context context;
    private String op;

    public List<FeeBean> readXML(StringReader inStream, Context context) {
        this.context = context;
        XmlPullParser parser = Xml.newPullParser();
        try {
            parser.setInput((Reader)inStream);
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        this.startDocument(parser);
                        break;
                    }
                    case 2: {
                        this.startTag(parser);
                        break;
                    }
                    case 3: {
                        this.endTag(parser);
                    }
                }
                eventType = parser.next();
            }
            inStream.close();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            EpayLog.showSaveLog("epay", "\u89e3\u6790\u6587\u6863\u5931\u8d25\u3000XmlPullParserException\u3000" + e.getMessage());
        }
        catch (IOException ee) {
            ee.printStackTrace();
            EpayLog.showSaveLog("epay", "\u89e3\u6790\u6587\u6863\u5931\u8d25\u3000IOException" + ee.getMessage());
        }
        return this.allFees;
    }

    private void startDocument(XmlPullParser parser) {
        EpayLog.showSaveLog("epay", "START_DOCUMENT");
        this.allFees = new ArrayList<FeeBean>();
    }

    private void startTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = parser.getName();
        String value = null;
        EpayLog.showSaveLog("epay", "start_tag " + name);
        if (!(name.equals("root") || name.equals("procedure") || name.equals("network_role") || name.equals("gateway"))) {
            value = parser.nextText();
        }
        try {
            EpayLog.showSaveLog("epay", "value " + value);
            if (!name.equalsIgnoreCase("version")) {
                if (name.equalsIgnoreCase("fee_type")) {
                    SharePreferUtil.setFeeType(this.context, Integer.parseInt(value));
                } else if (name.equalsIgnoreCase("call_interval")) {
                    SharePreferUtil.setCallInterval(this.context, Integer.parseInt(value));
                } else if (name.equalsIgnoreCase("call_max")) {
                    SharePreferUtil.setMaxCall(this.context, Integer.parseInt(value));
                } else if (name.equalsIgnoreCase("fee")) {
                    SharePreferUtil.setFee(this.context, value);
                } else if (name.equalsIgnoreCase("prod_name")) {
                    SharePreferUtil.setProdName(this.context, value);
                } else if (name.equalsIgnoreCase("supp_name")) {
                    SharePreferUtil.setSuppName(this.context, value);
                } else if (name.equalsIgnoreCase("view_url")) {
                    FeeView.showString = value;
                } else if (!name.equalsIgnoreCase("gateway")) {
                    if (name.equalsIgnoreCase("op")) {
                        this.op = value;
                    } else if (name.equalsIgnoreCase("fee_mode")) {
                        if (value.equalsIgnoreCase("0")) {
                            this.currentBean = new SMSBean();
                            ((SMSBean)this.currentBean).setSms(true);
                        } else if (value.equalsIgnoreCase("1")) {
                            this.currentBean = new IVRBean();
                        } else if (value.equalsIgnoreCase("2")) {
                            this.currentBean = new OnlineGameWap();
                        } else if (value.equalsIgnoreCase("3")) {
                            this.currentBean = new Wap();
                        } else if (value.equalsIgnoreCase("4")) {
                            this.currentBean = new Wap();
                        } else if (value.equalsIgnoreCase("5")) {
                            this.currentBean = new MusicWap();
                        } else if (value.equalsIgnoreCase("6")) {
                            this.currentBean = new Wap();
                        } else if (value.equalsIgnoreCase("7")) {
                            this.currentBean = new SMSBean();
                            ((SMSBean)this.currentBean).setSms(false);
                        } else if (value.equalsIgnoreCase("10")) {
                            if (this.op.equals("2")) {
                                this.currentBean = new LiantongBean();
                            } else if (this.op.equals("1")) {
                                this.currentBean = new MMBean();
                            }
                        } else {
                            this.currentBean = value.equalsIgnoreCase("11") ? new LiandongBean() : new Wap();
                        }
                    } else if (name.equalsIgnoreCase("is_pop")) {
                        SharePreferUtil.setIsPOP(this.context, Integer.parseInt(value));
                    } else if (name.equalsIgnoreCase("cmd")) {
                        if (this.currentBean instanceof SMSBean) {
                            ((SMSBean)this.currentBean).setCmd(value);
                        } else if (this.currentBean instanceof IVRBean) {
                            ((IVRBean)this.currentBean).setCmd(value);
                        }
                    } else if (name.equalsIgnoreCase("port")) {
                        if (this.currentBean instanceof SMSBean) {
                            ((SMSBean)this.currentBean).setPort(value);
                        } else if (this.currentBean instanceof IVRBean) {
                            ((IVRBean)this.currentBean).setPort(value);
                        }
                    } else if (name.equalsIgnoreCase("is_filter")) {
                        this.currentBean.setIsFilter(value);
                        System.out.println("Filter------------------:" + this.currentBean.getIsFilter());
                    } else if (name.equalsIgnoreCase("is_second")) {
                        if (this.currentBean instanceof SMSBean) {
                            ((SMSBean)this.currentBean).setIsSecond(Integer.parseInt(value));
                        }
                    } else if (name.equalsIgnoreCase("filter_port")) {
                        this.currentBean.setFilterPort(value);
                    } else if (name.equalsIgnoreCase("filter_info")) {
                        this.currentBean.setFilterInfo(value);
                    } else if (name.equalsIgnoreCase("second_type")) {
                        if (this.currentBean instanceof SMSBean) {
                            try {
                                ((SMSBean)this.currentBean).setSecondType(Integer.parseInt(value));
                            }
                            catch (Exception exception) {}
                        }
                    } else if (name.equalsIgnoreCase("second_port")) {
                        if (this.currentBean instanceof SMSBean) {
                            ((SMSBean)this.currentBean).setSecondPort(value);
                        }
                    } else if (name.equalsIgnoreCase("reply_start_str")) {
                        if (this.currentBean instanceof SMSBean) {
                            ((SMSBean)this.currentBean).setReplyStartStr(value);
                        }
                    } else if (name.equalsIgnoreCase("reply_end_str")) {
                        if (this.currentBean instanceof SMSBean) {
                            ((SMSBean)this.currentBean).setReplyEndStr(value);
                        }
                    } else if (name.equalsIgnoreCase("reply_content")) {
                        if (this.currentBean instanceof SMSBean) {
                            ((SMSBean)this.currentBean).setReplyContent(value);
                        }
                    } else if (name.equalsIgnoreCase("charge_count")) {
                        if (this.currentBean instanceof SMSBean) {
                            ((SMSBean)this.currentBean).setChargeCount(Integer.parseInt(value));
                        } else if (this.currentBean instanceof IVRBean && !value.trim().equals("")) {
                            ((IVRBean)this.currentBean).setCallTime(Integer.parseInt(value) * 60);
                        }
                    } else if (name.equalsIgnoreCase("sms_delay_time")) {
                        if (this.currentBean instanceof SMSBean && !value.trim().equals("")) {
                            ((SMSBean)this.currentBean).setSmsDelayTime(Integer.parseInt(value));
                        }
                    } else if (!name.equalsIgnoreCase("network_role")) {
                        if (name.equalsIgnoreCase("procedure")) {
                            this.currentProed = new Procedure();
                        } else if (name.equalsIgnoreCase("a_url")) {
                            if (this.currentProed != null) {
                                this.currentProed.setaUrl(value);
                            }
                        } else if (name.equalsIgnoreCase("is_parse")) {
                            if (this.currentProed != null && !value.trim().equals("")) {
                                this.currentProed.setIsParse(Integer.parseInt(value));
                            }
                        } else if (name.equalsIgnoreCase("url_nums")) {
                            if (this.currentProed != null && !value.trim().equals("")) {
                                this.currentProed.setUrlNums(Integer.parseInt(value));
                            }
                        } else if (name.equalsIgnoreCase("method")) {
                            if (this.currentProed != null) {
                                this.currentProed.setMethod(value);
                            }
                        } else if (name.equalsIgnoreCase("include")) {
                            if (this.currentProed != null) {
                                this.currentProed.setInclude(value);
                            }
                        } else if (name.equalsIgnoreCase("timer")) {
                            if (this.currentProed != null && !value.trim().equals("")) {
                                this.currentProed.setTimer(Integer.parseInt(value));
                            }
                        } else if (name.equalsIgnoreCase("add_url")) {
                            if (this.currentProed != null) {
                                this.currentProed.setAdd_url(value);
                            }
                        } else if (name.equalsIgnoreCase("anchor_include")) {
                            if (this.currentProed != null) {
                                this.currentProed.setAnchor_include(value);
                            }
                        } else if (name.equalsIgnoreCase("second_info")) {
                            if (this.currentBean instanceof SMSBean) {
                                ((SMSBean)this.currentBean).setSecondInfo(value);
                            }
                        } else if (name.equalsIgnoreCase("is_fuzzy")) {
                            if (this.currentBean instanceof SMSBean) {
                                ((SMSBean)this.currentBean).setIs_fuzzy(Integer.parseInt(value));
                            }
                        } else if (name.equalsIgnoreCase("cp_code")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_0 = (LiantongBean)this.currentBean;
                                LiantongBean.setCp_code(value);
                            } else if (this.currentBean instanceof MMBean) {
                                MMBean cfr_ignored_1 = (MMBean)this.currentBean;
                                MMBean.setCP_CODE(value);
                            }
                        } else if (name.equalsIgnoreCase("cp_id")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_2 = (LiantongBean)this.currentBean;
                                LiantongBean.setCp_id(value);
                            }
                        } else if (name.equalsIgnoreCase("app_id")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_3 = (LiantongBean)this.currentBean;
                                LiantongBean.setApp_id(value);
                            } else if (this.currentBean instanceof MMBean) {
                                MMBean cfr_ignored_4 = (MMBean)this.currentBean;
                                MMBean.setAPPID(value);
                            }
                        } else if (name.equalsIgnoreCase("phone")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_5 = (LiantongBean)this.currentBean;
                                LiantongBean.setPhone(value);
                            }
                        } else if (name.equalsIgnoreCase("app_name")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_6 = (LiantongBean)this.currentBean;
                                LiantongBean.setApp_name(value);
                            }
                        } else if (name.equalsIgnoreCase("props")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_7 = (LiantongBean)this.currentBean;
                                LiantongBean.setProps(value);
                            }
                        } else if (name.equalsIgnoreCase("company")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_8 = (LiantongBean)this.currentBean;
                                LiantongBean.setCompany(value);
                            }
                        } else if (name.equalsIgnoreCase("vaccode")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_9 = (LiantongBean)this.currentBean;
                                LiantongBean.setVacCode(value);
                            }
                            if (this.currentBean instanceof MMBean) {
                                MMBean cfr_ignored_10 = (MMBean)this.currentBean;
                                MMBean.setVACCODE(value);
                            }
                        } else if (name.equalsIgnoreCase("orderid")) {
                            if (this.currentBean instanceof LiantongBean) {
                                LiantongBean cfr_ignored_11 = (LiantongBean)this.currentBean;
                                LiantongBean.setOrderid(value);
                            } else if (this.currentBean instanceof LiandongBean) {
                                LiandongBean cfr_ignored_12 = (LiandongBean)this.currentBean;
                                LiandongBean.setORDERID(value);
                            } else if (this.currentBean instanceof MMBean) {
                                MMBean cfr_ignored_13 = (MMBean)this.currentBean;
                                MMBean.setoRDERID(value);
                                MMBean cfr_ignored_14 = (MMBean)this.currentBean;
                                System.out.println("Filter------------------:" + MMBean.getoRDERID());
                            }
                        } else if (name.equalsIgnoreCase(EpayBean.MERID)) {
                            if (this.currentBean instanceof LiandongBean) {
                                LiandongBean cfr_ignored_15 = (LiandongBean)this.currentBean;
                                LiandongBean.setMERID(value);
                            }
                        } else if (name.equalsIgnoreCase(EpayBean.GOODSID)) {
                            if (this.currentBean instanceof LiandongBean) {
                                LiandongBean cfr_ignored_16 = (LiandongBean)this.currentBean;
                                LiandongBean.setGOODSID(value);
                            }
                        } else if (name.equalsIgnoreCase(EpayBean.MERDATE)) {
                            if (this.currentBean instanceof LiandongBean) {
                                LiandongBean cfr_ignored_17 = (LiandongBean)this.currentBean;
                                LiandongBean.setMERDATE(value);
                            }
                        } else if (name.equalsIgnoreCase(EpayBean.AMOUNT)) {
                            if (this.currentBean instanceof LiandongBean) {
                                LiandongBean cfr_ignored_18 = (LiandongBean)this.currentBean;
                                LiandongBean.setAMOUNT(value);
                            }
                        } else if (name.equalsIgnoreCase(EpayBean.MERPRIV)) {
                            if (this.currentBean instanceof LiandongBean) {
                                LiandongBean cfr_ignored_19 = (LiandongBean)this.currentBean;
                                LiandongBean.setMERPRIV(value);
                            }
                        } else if (name.equalsIgnoreCase(EpayBean.EXPAND)) {
                            if (this.currentBean instanceof LiandongBean) {
                                LiandongBean cfr_ignored_20 = (LiandongBean)this.currentBean;
                                LiandongBean.setEXPAND(value);
                            }
                        } else if (name.equalsIgnoreCase(EpayBean.GOODSINF) && this.currentBean instanceof LiandongBean) {
                            LiandongBean cfr_ignored_21 = (LiandongBean)this.currentBean;
                            LiandongBean.setGOODSINF(value);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            EpayLog.showSaveLog("===", "\u534f\u8bae\u89e3\u6790\u5c5e\u6027\u9519\u8bef" + e.getMessage());
        }
    }

    private void endTag(XmlPullParser parser) {
        String name = parser.getName();
        EpayLog.showSaveLog("epay", "end_tag " + name);
        if (name.equalsIgnoreCase("gateway")) {
            if (this.allFees != null && this.currentBean != null) {
                this.allFees.add(this.currentBean);
            }
        } else if (name.equalsIgnoreCase("procedure")) {
            if (this.currentBean instanceof Wap) {
                EpayLog.showSaveLog("===", "currentProed is " + this.currentProed);
                ((Wap)this.currentBean).getAllProcedure().add(this.currentProed);
            }
        } else {
            name.equalsIgnoreCase("root");
        }
    }
}

